#!/bin/bash
installDir=/opt/tiflux
etc="$installDir/etc"
dependencies="$installDir/dependencies"
assets="$installDir/assets"
logs="$installDir/logs"
bin="$installDir/bin"
serviceBin="tiflux-agent"
trayDir="$bin/tray"
trayBin="tiflux-tray"
confirmDir="$bin/confirm"
confirmBin="ticonfirm"

if [ "$EUID" -ne 0 ]
  then echo "Please run as root"
  exit 1
fi

if [ "`uname -m`" == "i386" ] || [ "`uname -m`" == "i686" ]
then
  echo "TiFlux Agent doesn't support 32 bits systems"
  arch="386"
  exit 1
else
  arch="amd64"
fi

if [ $SUDO_USER ]; then user=$SUDO_USER; else user=`whoami`; fi
if [ $user == "root" ]; then
    user=`last |head -n 1 |awk '{print $1}'`
fi

echo "Verifying old agent instances"
oldAgent="/usr/bin/tiagent-last"
if [ -f "$oldAgent" ]; then
    echo "Uninstalling old agent instance"
    /bin/kill -9 `pgrep tiagent-last` 2> /dev/null
    /bin/sleep 3
    /bin/rm -f $oldAgent
fi

echo "Creating dirs..."
mkdir -p $dependencies
mkdir -p $etc
mkdir -p $logs
mkdir -p $trayDir
mkdir -p $confirmDir
mkdir -p $assets

echo "Checking dependencies"
which apt &> /dev/null
if [ $? -eq 0 ]; then
  libAyatana="libayatana-appindicator3-1"
  apt install --yes $libAyatana
  TRAY_LEGACY=0
  if [ -z "$(dpkg -l |grep $libAyatana)" ]; then
    apt install --yes libappindicator3-1
    TRAY_LEGACY=1
  fi
  apt install --yes lm-sensors smartmontools curl
fi

which yum &> /dev/null
if [ $? -eq 0 ]; then
  libAyatana="libayatana-indicator"
  yum -y install $libAyatana
  TRAY_LEGACY=0
  if [ -z "$(yum list installed |grep $libAyatana)" ]; then
    yum -y install libappindicator-gtk3
    TRAY_LEGACY=1
  fi
  yum -y install lm_sensors smartmontools
fi

echo "Installing files"
CUR_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
cp -rf $CUR_DIR/../opt/tiflux/* $installDir
cp -rf $CUR_DIR/../usr/share/applications/* /usr/share/applications/
cp -rf $CUR_DIR/../etc/logrotate.d/* /etc/logrotate.d/
ln -sf $trayDir/$trayBin /usr/bin/tiflux-tray
ln -sf $trayDir/$trayBin /opt/tiflux/tiflux-tray
ln -sf $bin/$serviceBin /usr/bin/tiflux-agent 
ln -sf $bin/$serviceBin /opt/tiflux/tiflux-agent
ln -sf $confirmDir/$confirmBin /opt/tiflux/ticonfirm
ln -sf /usr/share/applications/tiagent.desktop /etc/xdg/autostart/tiagent.desktop

if [ $TRAY_LEGACY == 1 ]; then
  echo "libayatana-appindicator3-1 not detected, downloading legacy system tray..."
  curl -o $trayDir/$trayBin https://central.onne.net.br/core/main/agent_update/tiflux-tray-legacy/bin/1.0.3/linux-amd64 > /dev/null 2>&1
fi


echo "Setting permisions"
chmod 755 $etc
chmod 766 "$etc/conf.json"
chmod 777 $logs $assets $trayDir $confirmDir
chmod 775 "$bin/$serviceBin"
chmod 775 "$bin/uninstall"
chmod 777 "$trayDir/$trayBin"
chmod 777 "$confirmDir/$confirmBin"

"/usr/bin/$serviceBin" installService
"/usr/bin/$serviceBin" start

echo "Starting agent tray"
sleep 2
sudo -u $user /usr/bin/$trayBin > /dev/null 2>&1 &